    /*
     *
     * copyright (c) 2013-2021 Heliac Technologies
     * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
     *
     * linee guida per l'utilizzo del logo https://www.geecom.org/?alias=linee-guida-per-luso-del-logo-geecom

       questo file mostra i commenti in una tabella. viene usato nella home page e nella pagina commenti
     */
    generaSecretStripe("secret");
    
    var paymentIntentClientSecret = document.getElementById("secret").value;
    var publishedKey = document.getElementById("chiavePubblica").value;
    var paymentForm  = document.getElementById("payment-form");
    
    stripe = Stripe(publishedKey);
    var elements = stripe.elements();
    var style = {
        base: {
            color: "#32325d",
            fontFamily: '"Helvetica Neue", Helvetica, sans-serif',
            fontSmoothing: "antialiased",
            fontSize: "16px",
            "::placeholder": {
                color: "#aab7c4"
            }
        },
        invalid: {
          color: "#fa755a",
          iconColor: "#fa755a"
        }
    };

    var card = elements.create("card", { style: style });
    card.mount("#card-element");

    // Handle form submission.
    paymentForm.addEventListener("submit", function(event) {
        event.preventDefault();
        // Initiate payment when the submit button is clicked
        pay(stripe, card, paymentIntentClientSecret);
    });


/*
  * Calls stripe.confirmCardPayment which creates a pop-up modal to
  * prompt the user to enter extra authentication details without leaving your page
  */
function pay(stripe, card, clientSecret) {
  changeLoadingState(true);

  // Initiate the payment.
  // If authentication is required, confirmCardPayment will automatically display a modal
  stripe
    .confirmCardPayment(clientSecret, {
      payment_method: {
        card: card
      }
    })
    .then(function(result) {
      if (result.error) {
        // Show error to your customer
        showError(result.error.message);
      } else {
        // The payment has been processed!
        orderComplete(clientSecret);
      }
    });
}

/* ------- Post-payment helpers ------- */

/* Shows a success / error message when the payment is complete */
var orderComplete = function(clientSecret) {
    // Just for the purpose of the sample, show the PaymentIntent response object
    stripe.retrievePaymentIntent(clientSecret).then(function(result) {
        var paymentIntent = result.paymentIntent;
        
        document.querySelector(".sr-payment-form").classList.add("hidden");
        impostaOrdineStripecomePagatoEdEseguiRedirect(paymentIntent.id);
        
        document.querySelector(".sr-result").classList.remove("hidden");
        setTimeout(function() {
          document.querySelector(".sr-result").classList.add("expand");
        }, 200);

        changeLoadingState(false);
    });
};

var showError = function(errorMsgText) {
  changeLoadingState(false);
  var errorMsg = document.querySelector(".sr-field-error");
  errorMsg.textContent = errorMsgText;
  setTimeout(function() {
    errorMsg.textContent = "";
  }, 4000);
};

// Show a spinner on payment submission
var changeLoadingState = function(isLoading) {
  if (isLoading) {
    document.querySelector("button").disabled = true;
    document.querySelector("#spinner").classList.remove("hidden");
    document.querySelector("#button-text").classList.add("hidden");
  } else {
    document.querySelector("button").disabled = false;
    document.querySelector("#spinner").classList.add("hidden");
    document.querySelector("#button-text").classList.remove("hidden");
  }
};